/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.MotionResources;
import edu.colorado.phet.common.motion.graphs.ControlGraph;
import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class MinimizableControlGraph
extends PNode {
    private String label;
    private boolean minimized = false;
    private PNode graphChild;
    private PNode stubChild;
    private ArrayList listeners = new ArrayList();
    private ControlGraph controlGraph;
    private PSwing closeButton;

    public MinimizableControlGraph(String string, ControlGraph controlGraph) {
        this(string, controlGraph, false);
    }

    public MinimizableControlGraph(String string, ControlGraph controlGraph, boolean bl) {
        this.label = string;
        this.graphChild = new PNode();
        this.stubChild = new PNode();
        this.controlGraph = controlGraph;
        this.graphChild.addChild(controlGraph);
        JButton jButton = new JButton();
        try {
            jButton.setIcon(new ImageIcon(MotionResources.loadBufferedImage("minimizeButton.png")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MinimizableControlGraph.this.setMinimized(true);
            }
        });
        this.closeButton = new PSwing(jButton);
        this.closeButton.addInputEventListener(new CursorHandler());
        this.graphChild.addChild(this.closeButton);
        this.addChild(this.graphChild);
        JButton jButton2 = new JButton("Maximize " + string + " graph");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MinimizableControlGraph.this.setMinimized(false);
            }
        });
        try {
            jButton2.setIcon(new ImageIcon(MotionResources.loadBufferedImage("maximizeButton.png")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        PSwing pSwing = new PSwing(jButton2);
        pSwing.addInputEventListener(new CursorHandler());
        this.stubChild.addChild(pSwing);
        this.relayout();
        this.setMinimized(bl);
    }

    public ControlGraph getControlGraph() {
        return this.controlGraph;
    }

    private void updateCloseButton() {
        int n = 3;
        int n2 = 3;
        this.controlGraph.getJFreeChartNode().updateChartRenderingInfo();
        this.closeButton.setOffset(this.controlGraph.getJFreeChartNode().getDataArea().getMaxX() - this.closeButton.getFullBounds().getWidth() - (double)n + this.controlGraph.getJFreeChartNode().getOffset().getX(), this.controlGraph.getJFreeChartNode().getDataArea().getY());
    }

    public void setMinimized(boolean bl) {
        if (this.minimized != bl) {
            this.minimized = bl;
            if (this.minimized) {
                this.removeChild(this.graphChild);
                this.addChild(this.stubChild);
            } else {
                this.removeChild(this.stubChild);
                this.addChild(this.graphChild);
            }
            this.relayout();
            this.notifyListeners();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setAvailableBounds(double d, double d2) {
        this.controlGraph.setBounds(0.0, 0.0, d, d2);
        this.relayout();
    }

    private void relayout() {
        this.updateCloseButton();
        this.stubChild.setOffset(this.controlGraph.getFullBounds().getMaxX() - this.stubChild.getFullBounds().getWidth(), 0.0);
    }

    public double getFixedHeight() {
        return this.minimized ? this.stubChild.getFullBounds().getHeight() : 0.0;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void clear() {
        this.controlGraph.clear();
    }

    public void setFlowLayout() {
        this.controlGraph.setFlowLayout();
    }

    public void setAlignedLayout(MinimizableControlGraph[] minimizableControlGraphArray) {
        this.controlGraph.setAlignedLayout(minimizableControlGraphArray);
    }

    public void relayoutControlGraph() {
        this.controlGraph.relayout();
    }

    public void forceUpdate() {
        this.controlGraph.getDynamicJFreeChartNode().forceUpdateAll();
    }

    public void resetRange() {
        this.controlGraph.resetRange();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.minimizeStateChanged();
        }
    }

    public void addSeries(ControlGraphSeries controlGraphSeries) {
        this.getControlGraph().addSeries(controlGraphSeries);
    }

    public void addControl(JComponent jComponent) {
        this.getControlGraph().addControl(jComponent);
    }

    public static interface Listener {
        public void minimizeStateChanged();
    }
}

