/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.GraphSuite;
import edu.colorado.phet.common.motion.graphs.MinimizableControlGraph;
import edu.colorado.phet.common.motion.graphs.MotionControlGraph;
import java.util.ArrayList;

public class GraphSuiteSet {
    protected ArrayList suites = new ArrayList();
    private MotionControlGraph.Listener zoomListener = new MotionControlGraph.Listener(){

        public void horizontalZoomChanged(MotionControlGraph motionControlGraph) {
            GraphSuiteSet.this.setDomainUpperBound(motionControlGraph.getMaxDataX());
        }
    };

    public void setDomainUpperBound(double d) {
        MinimizableControlGraph[] minimizableControlGraphArray = this.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            minimizableControlGraphArray[i].getControlGraph().setDomainUpperBound(d);
        }
    }

    public MinimizableControlGraph[] getAllGraphs() {
        ArrayList<MinimizableControlGraph> arrayList = new ArrayList<MinimizableControlGraph>();
        for (int i = 0; i < this.suites.size(); ++i) {
            GraphSuite graphSuite = (GraphSuite)this.suites.get(i);
            for (int j = 0; j < graphSuite.getGraphComponentCount(); ++j) {
                if (arrayList.contains(graphSuite.getGraphComponent(j))) continue;
                arrayList.add(graphSuite.getGraphComponent(j));
            }
        }
        return arrayList.toArray(new MinimizableControlGraph[0]);
    }

    public GraphSuite getGraphSuite(int n) {
        return (GraphSuite)this.suites.get(n);
    }

    public void addGraphSuite(MinimizableControlGraph[] minimizableControlGraphArray) {
        this.addGraphSuite(new GraphSuite(minimizableControlGraphArray));
    }

    public void addGraphSuite(GraphSuite graphSuite) {
        this.suites.add(graphSuite);
        this.updateListeners();
    }

    private void updateListeners() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            MotionControlGraph motionControlGraph;
            MinimizableControlGraph minimizableControlGraph = minimizableControlGraphArray[i];
            if (!(minimizableControlGraph.getControlGraph() instanceof MotionControlGraph) || (motionControlGraph = (MotionControlGraph)minimizableControlGraph.getControlGraph()).hasListener(this.zoomListener)) continue;
            motionControlGraph.addListener(this.zoomListener);
        }
    }

    public void clear() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            minimizableControlGraphArray[i].clear();
        }
        this.forceUpdateAll();
    }

    public int getNumGraphSuites() {
        return this.suites.size();
    }

    public void forceUpdateAll() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            minimizableControlGraphArray[i].forceUpdate();
        }
    }

    public void resetAll() {
        this.resetRange();
        this.maximizeAll();
        this.clear();
    }

    private void resetRange() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            minimizableControlGraphArray[i].resetRange();
        }
    }

    private void maximizeAll() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            minimizableControlGraphArray[i].setMinimized(false);
        }
    }
}

