/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSuite;
import edu.colorado.phet.common.motion.graphs.MinimizableControlGraph;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;

public class GraphSetNode
extends PNode {
    private GraphSetModel graphSetModel;
    private ArrayList graphComponents = new ArrayList();
    private MinimizableControlGraph.Listener graphComponentListener;
    private double width;
    private double height;
    private Layout flow = new Layout(){

        public void update() {
            GraphSetNode.this.setFlowLayout();
        }
    };
    private Layout aligned = new Layout(){

        public void update() {
            GraphSetNode.this.setAlignedLayout();
        }
    };
    private Layout layout = this.flow;

    public GraphSetNode(GraphSetModel graphSetModel) {
        this.graphSetModel = graphSetModel;
        this.graphComponentListener = new MinimizableControlGraph.Listener(){

            public void minimizeStateChanged() {
                GraphSetNode.this.relayout();
            }
        };
        graphSetModel.addListener(new GraphSetModel.Listener(){

            public void graphSuiteChanged() {
                GraphSetNode.this.updateGraphSuite();
            }
        });
        this.updateGraphSuite();
    }

    public void forceRepaintGraphs() {
        for (int i = 0; i < this.graphComponents.size(); ++i) {
            MinimizableControlGraph minimizableControlGraph = (MinimizableControlGraph)this.graphComponents.get(i);
            if (!minimizableControlGraph.getVisible() || minimizableControlGraph.isMinimized()) continue;
            minimizableControlGraph.forceUpdate();
        }
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        this.width = d3;
        this.height = d4;
        this.relayout();
        this.setOffset(d, d2);
    }

    private void updateGraphSuite() {
        while (this.graphComponents.size() > 0) {
            this.removeGraphComponent(0);
        }
        GraphSuite graphSuite = this.graphSetModel.getGraphSuite();
        for (int i = 0; i < graphSuite.getGraphComponentCount(); ++i) {
            this.addGraphComponent(graphSuite.getGraphComponent(i));
        }
        this.updateLayout();
        this.relayout();
    }

    private void addGraphComponent(MinimizableControlGraph minimizableControlGraph) {
        this.graphComponents.add(minimizableControlGraph);
        this.addChild(minimizableControlGraph);
        minimizableControlGraph.addListener(this.graphComponentListener);
        this.updateLayout();
    }

    public void forceRelayout() {
        this.relayout();
    }

    private void relayout() {
        double d = 5.0;
        double d2 = this.height;
        for (int i = 0; i < this.graphComponents.size(); ++i) {
            MinimizableControlGraph minimizableControlGraph = (MinimizableControlGraph)this.graphComponents.get(i);
            d2 -= minimizableControlGraph.getFixedHeight();
            d2 -= d;
        }
        double d3 = 0.0;
        double d4 = Math.min(d2 / (double)this.numMaximized(), d2 / 2.0);
        for (int i = 0; i < this.graphComponents.size(); ++i) {
            MinimizableControlGraph minimizableControlGraph = this.getGraphComponent(i);
            minimizableControlGraph.setOffset(0.0, d3);
            if (this.numMaximized() > 0) {
                minimizableControlGraph.setAvailableBounds(this.width, d4);
            }
            d3 += minimizableControlGraph.getFullBounds().getHeight() + d;
        }
        this.relayoutControlGraphs();
        this.forceRepaintGraphs();
    }

    private int numMaximized() {
        int n = 0;
        for (int i = 0; i < this.graphComponents.size(); ++i) {
            MinimizableControlGraph minimizableControlGraph = (MinimizableControlGraph)this.graphComponents.get(i);
            n += minimizableControlGraph.isMinimized() ? 0 : 1;
        }
        return n;
    }

    private void removeGraphComponent(int n) {
        MinimizableControlGraph minimizableControlGraph = (MinimizableControlGraph)this.graphComponents.remove(n);
        minimizableControlGraph.removeListener(this.graphComponentListener);
        this.removeChild(minimizableControlGraph);
        this.updateLayout();
    }

    private void updateLayout() {
        this.layout.update();
    }

    private MinimizableControlGraph getGraphComponent(int n) {
        return (MinimizableControlGraph)this.graphComponents.get(n);
    }

    public void setFlowLayout() {
        for (int i = 0; i < this.graphComponents.size(); ++i) {
            MinimizableControlGraph minimizableControlGraph = (MinimizableControlGraph)this.graphComponents.get(i);
            minimizableControlGraph.setFlowLayout();
        }
        this.layout = this.flow;
    }

    public void setAlignedLayout() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.graphComponents.toArray(new MinimizableControlGraph[0]);
        for (int i = 0; i < this.graphComponents.size(); ++i) {
            MinimizableControlGraph minimizableControlGraph = (MinimizableControlGraph)this.graphComponents.get(i);
            minimizableControlGraph.setAlignedLayout(minimizableControlGraphArray);
        }
        this.relayoutControlGraphs();
        this.layout = this.aligned;
    }

    private void relayoutControlGraphs() {
        for (int i = 0; i < this.graphComponents.size(); ++i) {
            MinimizableControlGraph minimizableControlGraph = (MinimizableControlGraph)this.graphComponents.get(i);
            minimizableControlGraph.relayoutControlGraph();
        }
    }

    static interface Layout {
        public void update();
    }
}

