/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSuite;
import edu.colorado.phet.common.motion.graphs.GraphSuiteSet;
import edu.colorado.phet.common.motion.util.GraphicsUtil;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GraphSelectionControl
extends JPanel {
    public GraphSelectionControl(GraphSuiteSet graphSuiteSet, GraphSetModel graphSetModel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        JLabel jLabel = new JLabel(PhetCommonResources.getString("charts.show-graphs"));
        jLabel.setFont(new PhetFont(0, 16));
        this.add((Component)jLabel, gridBagConstraints);
        for (int i = 0; i < graphSuiteSet.getNumGraphSuites(); ++i) {
            this.add((Component)new GraphSuiteRadioButton(graphSetModel, graphSuiteSet.getGraphSuite(i)), gridBagConstraints);
        }
    }

    public static class GraphSuiteRadioButton
    extends JRadioButton {
        private GraphSetModel graphSetPanel;
        private GraphSuite graphSuite;

        public GraphSuiteRadioButton(final GraphSetModel graphSetModel, final GraphSuite graphSuite) {
            super(graphSuite.getLabel(), graphSetModel.getGraphSuite() == graphSuite);
            this.graphSetPanel = graphSetModel;
            this.graphSuite = graphSuite;
            this.setFont(new PhetFont(0, 16));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    graphSetModel.setGraphSuite(graphSuite);
                }
            });
            graphSetModel.addListener(new GraphSetModel.Listener(){

                public void graphSuiteChanged() {
                    GraphSuiteRadioButton.this.setSelected(graphSetModel.getGraphSuite() == graphSuite);
                }
            });
        }

        protected void paintComponent(Graphics graphics) {
            boolean bl = GraphicsUtil.antialias(graphics, true);
            super.paintComponent(graphics);
            GraphicsUtil.antialias(graphics, bl);
        }
    }
}

