/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesData;
import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphControlSeriesNode;
import edu.colorado.phet.common.motion.graphs.GraphControlTextBox;
import edu.colorado.phet.common.motion.graphs.GraphTimeControlNode;
import edu.colorado.phet.common.motion.graphs.JFreeChartDecorator;
import edu.colorado.phet.common.motion.graphs.JFreeChartSliderNode;
import edu.colorado.phet.common.motion.graphs.MinimizableControlGraph;
import edu.colorado.phet.common.motion.graphs.ReadoutTitleNode;
import edu.colorado.phet.common.motion.graphs.ZoomSuiteNode;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.tests.ColorArrows;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ZoomControlNode;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ControlGraph
extends PNode {
    private JFreeChart jFreeChart;
    private DynamicJFreeChartNode dynamicJFreeChartNode;
    private GraphTimeControlNode graphTimeControlNode;
    private JFreeChartSliderNode jFreeChartSliderNode;
    private ZoomSuiteNode zoomControl;
    private TitleLayer titleLayer;
    private double ZOOM_FRACTION = 1.1;
    private Layout layout = new FlowLayout();
    private ArrayList series = new ArrayList();
    private ArrayList listeners = new ArrayList();
    private PSwing additionalControls;
    private VerticalLayoutPanel additionalControlPanel = new VerticalLayoutPanel();
    private IVariable variable;
    private double defaultMinY;
    private double defaultMaxY;
    private double defaultMaxX;
    private double minViewableX = 0.0;
    private double maxViewableX;

    public ControlGraph(JFreeChart jFreeChart, PhetPCanvas phetPCanvas, ControlGraphSeries controlGraphSeries, double d, double d2, TimeSeriesModel timeSeriesModel, double d3) {
        this.jFreeChart = jFreeChart;
        PImage pImage = null;
        if (controlGraphSeries != null) {
            this.variable = controlGraphSeries.getTemporalVariable();
            this.variable.addListener(new IVariable.Listener(){

                public void valueChanged() {
                    ControlGraph.this.updateSliderValue();
                }
            });
            pImage = new PImage(ColorArrows.createArrow(controlGraphSeries.getColor()));
        }
        this.maxViewableX = d3;
        this.defaultMinY = d;
        this.defaultMaxY = d2;
        this.defaultMaxX = d3;
        this.zoomControl = new ZoomSuiteNode();
        this.titleLayer = this.createTitleLayer();
        this.dynamicJFreeChartNode = new DynamicJFreeChartNode(phetPCanvas, jFreeChart);
        this.dynamicJFreeChartNode.setBuffered(true);
        this.dynamicJFreeChartNode.setBounds(0.0, 0.0, 300.0, 400.0);
        this.dynamicJFreeChartNode.setBufferedImmediateSeries();
        jFreeChart.setTitle((String)null);
        this.setVerticalRange(d, d2);
        this.setDomain(0.0, d3);
        jFreeChart.setBackgroundPaint(null);
        this.graphTimeControlNode = this.createGraphTimeControlNode(timeSeriesModel);
        this.additionalControls = new PSwing(this.additionalControlPanel);
        this.jFreeChartSliderNode = this.createSliderNode(pImage, controlGraphSeries != null ? controlGraphSeries.getColor() : Color.yellow);
        this.zoomControl.addVerticalZoomListener(new ZoomControlNode.ZoomListener(){

            public void zoomedOut() {
                ControlGraph.this.zoomVertical(ControlGraph.this.ZOOM_FRACTION);
            }

            public void zoomedIn() {
                ControlGraph.this.zoomVertical(1.0 / ControlGraph.this.ZOOM_FRACTION);
            }
        });
        this.zoomControl.addHorizontalZoomListener(new ZoomControlNode.ZoomListener(){

            public void zoomedOut() {
                ControlGraph.this.zoomHorizontal(ControlGraph.this.ZOOM_FRACTION);
            }

            public void zoomedIn() {
                ControlGraph.this.zoomHorizontal(1.0 / ControlGraph.this.ZOOM_FRACTION);
            }
        });
        this.addChild(this.graphTimeControlNode);
        this.addChild(this.additionalControls);
        this.addChild(this.jFreeChartSliderNode);
        this.addChild(this.dynamicJFreeChartNode);
        this.addChild(this.zoomControl);
        this.addChild(this.titleLayer);
        this.jFreeChartSliderNode.addListener(new JFreeChartSliderNode.Adapter(){

            public void sliderThumbGrabbed() {
                ControlGraph.this.notifyControlGrabbed();
            }

            public void sliderDragged(double d) {
                ControlGraph.this.handleValueChanged();
            }
        });
        this.dynamicJFreeChartNode.updateChartRenderingInfo();
        this.relayout();
        this.updateHorizontalZoomEnabled();
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void keyPressed(PInputEvent pInputEvent) {
                if (pInputEvent.getKeyCode() == 49) {
                    ControlGraph.this.dynamicJFreeChartNode.setJFreeChartSeries();
                } else if (pInputEvent.getKeyCode() == 50) {
                    ControlGraph.this.dynamicJFreeChartNode.setPiccoloSeries();
                } else if (pInputEvent.getKeyCode() == 51) {
                    ControlGraph.this.dynamicJFreeChartNode.setBufferedSeries();
                } else if (pInputEvent.getKeyCode() == 52) {
                    ControlGraph.this.dynamicJFreeChartNode.setBufferedImmediateSeries();
                }
            }
        });
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                pInputEvent.getInputManager().setKeyboardFocus(pInputEvent.getPath());
            }
        });
        if (controlGraphSeries != null) {
            this.addSeries(controlGraphSeries);
        }
        this.updateSliderValue();
    }

    public static JFreeChart createDefaultChart(String string) {
        return ControlGraph.createXYLineChart(string, null, null, new XYSeriesCollection(new XYSeries((Comparable)((Object)"dummy series"), false)), PlotOrientation.VERTICAL);
    }

    public static JFreeChart createXYLineChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation) {
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, xYLineAndShapeRenderer);
        xYPlot.setOrientation(plotOrientation);
        return new JFreeChartDecorator(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, false);
    }

    protected JFreeChartSliderNode createSliderNode(PNode pNode, Color color) {
        return new JFreeChartSliderNode(this.dynamicJFreeChartNode, pNode == null ? new PPath() : pNode, color);
    }

    public void setDomain(double d, double d2) {
        if (!this.jFreeChart.getXYPlot().getDomainAxis().getRange().equals(new Range(d, d2))) {
            this.jFreeChart.getXYPlot().getDomainAxis().setRange(d, d2);
            this.notifyZoomChanged();
            this.updateHorizontalZoomEnabled();
            this.forceUpdateAll();
        }
    }

    protected GraphTimeControlNode createGraphTimeControlNode(TimeSeriesModel timeSeriesModel) {
        return new GraphTimeControlNode(timeSeriesModel);
    }

    protected void updateSliderValue() {
        if (this.jFreeChartSliderNode != null && this.getSimulationVariable() != null) {
            this.jFreeChartSliderNode.setValue(this.getSimulationVariable().getValue());
        }
    }

    protected JFreeChartSliderNode getJFreeChartSliderNode() {
        return this.jFreeChartSliderNode;
    }

    public void setVerticalRange(double d, double d2) {
        this.jFreeChart.getXYPlot().getRangeAxis().setRange(d, d2);
    }

    protected TitleLayer createTitleLayer() {
        return new TitleLayer();
    }

    public IVariable getSimulationVariable() {
        return this.variable;
    }

    protected void handleValueChanged() {
        this.getSimulationVariable().setValue(this.getModelValue());
        this.notifyValueChanged(this.getModelValue());
    }

    public double getModelValue() {
        return this.getSliderValue();
    }

    protected void notifyValueChanged(double d) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.valueChanged(d);
        }
    }

    protected double getSliderValue() {
        return this.jFreeChartSliderNode.getValue();
    }

    public DynamicJFreeChartNode getDynamicJFreeChartNode() {
        return this.dynamicJFreeChartNode;
    }

    private void notifyControlGrabbed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.controlFocusGrabbed();
        }
    }

    public void addHorizontalZoomListener(ZoomControlNode.ZoomListener zoomListener) {
        this.zoomControl.addHorizontalZoomListener(zoomListener);
    }

    public void addControl(JComponent jComponent) {
        this.additionalControlPanel.add(jComponent);
        this.additionalControls.computeBounds();
    }

    protected void handleControlFocusGrabbed() {
    }

    public void resetRange() {
        this.setVerticalRange(this.defaultMinY, this.defaultMaxY);
        this.setDomain(0.0, this.defaultMaxX);
    }

    public double getDefaultMinY() {
        return this.defaultMinY;
    }

    public double getDefaultMaxY() {
        return this.defaultMaxY;
    }

    public double getDefaultMaxX() {
        return this.defaultMaxX;
    }

    protected void zoomHorizontal(double d) {
        double d2 = this.jFreeChart.getXYPlot().getDomainAxis().getUpperBound();
        double d3 = d2 * d;
        if (d3 > this.maxViewableX) {
            d3 = this.maxViewableX;
        }
        this.setDomainUpperBound(d3);
    }

    protected void notifyZoomChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).zoomChanged();
        }
    }

    protected void zoomVertical(double d) {
        Range range = this.getVerticalRange(d);
        this.setVerticalRange(range.getLowerBound(), range.getUpperBound());
        this.updateHorizontalZoomEnabled();
        this.notifyZoomChanged();
        this.forceUpdateAll();
    }

    protected Range getVerticalRange(double d) {
        double d2 = this.jFreeChart.getXYPlot().getRangeAxis().getUpperBound() - this.jFreeChart.getXYPlot().getRangeAxis().getLowerBound();
        double d3 = d2 * d - d2;
        return new Range(this.jFreeChart.getXYPlot().getRangeAxis().getLowerBound() - d3 / 2.0, this.jFreeChart.getXYPlot().getRangeAxis().getUpperBound() + d3 / 2.0);
    }

    protected void updateHorizontalZoomEnabled() {
        this.zoomControl.setHorizontalZoomOutEnabled(this.jFreeChart.getXYPlot().getDomainAxis().getUpperBound() != this.maxViewableX);
    }

    public ControlGraphSeries getControlGraphSeries(int n) {
        return (ControlGraphSeries)this.series.get(n);
    }

    public int getSeriesCount() {
        return this.series.size();
    }

    public void addSeries(final ControlGraphSeries controlGraphSeries) {
        this.series.add(controlGraphSeries);
        final SeriesData seriesData = this.dynamicJFreeChartNode.addSeries(controlGraphSeries.getTitle(), controlGraphSeries.getColor(), controlGraphSeries.getStroke());
        final ReadoutTitleNode readoutTitleNode = this.createReadoutTitleNode(controlGraphSeries);
        this.titleLayer.addReadoutNode(readoutTitleNode);
        GraphControlSeriesNode graphControlSeriesNode = null;
        if (controlGraphSeries.isEditable()) {
            graphControlSeriesNode = this.graphTimeControlNode.addVariable(controlGraphSeries);
            graphControlSeriesNode.addListener(new GraphControlTextBox.Listener(){

                public void valueChanged(double d) {
                    ControlGraph.this.notifyValueChanged(d);
                }
            });
            graphControlSeriesNode.getTextBox().getTextField().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    ControlGraph.this.handleControlFocusGrabbed();
                }
            });
        }
        controlGraphSeries.getTemporalVariable().addListener(new ITemporalVariable.ListenerAdapter(){

            public void dataAdded(TimeData timeData) {
                ControlGraph.this.handleDataAdded(ControlGraph.this.getSeriesIndex(controlGraphSeries), timeData);
            }

            public void dataCleared() {
                ControlGraph.this.clear();
            }
        });
        final GraphControlSeriesNode graphControlSeriesNode2 = graphControlSeriesNode;
        controlGraphSeries.addListener(new ControlGraphSeries.Adapter(){

            public void visibilityChanged() {
                ControlGraph.this.dynamicJFreeChartNode.setSeriesVisible(seriesData, controlGraphSeries.isVisible());
                readoutTitleNode.setVisible(controlGraphSeries.isVisible());
                if (graphControlSeriesNode2 != null) {
                    graphControlSeriesNode2.setVisible(controlGraphSeries.isVisible());
                }
                ControlGraph.this.getDynamicJFreeChartNode().forceUpdateAll();
            }
        });
    }

    protected ReadoutTitleNode createReadoutTitleNode(ControlGraphSeries controlGraphSeries) {
        return new ReadoutTitleNode(controlGraphSeries);
    }

    protected void handleDataAdded(int n, TimeData timeData) {
        this.addValue(n, timeData.getTime(), timeData.getValue());
    }

    protected int getSeriesIndex(ControlGraphSeries controlGraphSeries) {
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            if (this.getControlGraphSeries(i) != controlGraphSeries) continue;
            return i;
        }
        return -1;
    }

    public double getMaxDataX() {
        return this.jFreeChart.getXYPlot().getDomainAxis().getUpperBound();
    }

    public void setDomainUpperBound(double d) {
        this.setDomain(this.jFreeChart.getXYPlot().getDomainAxis().getLowerBound(), d);
    }

    public void setFlowLayout() {
        this.setLayout(new FlowLayout());
    }

    public void setAlignedLayout(MinimizableControlGraph[] minimizableControlGraphArray) {
        this.setLayout(new AlignedLayout(minimizableControlGraphArray));
    }

    public JFreeChartNode getJFreeChartNode() {
        return this.dynamicJFreeChartNode;
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        super.internalUpdateBounds(d, d2, d3, d4);
        this.relayout();
    }

    private static double getInsetX(JFreeChartNode jFreeChartNode) {
        PBounds pBounds = jFreeChartNode.getBounds();
        Rectangle2D rectangle2D = jFreeChartNode.getDataArea();
        return rectangle2D.getX() - ((RectangularShape)pBounds).getX();
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
        this.relayout();
    }

    public void relayout() {
        this.layout.layout();
    }

    private Rectangle2D.Double getDataArea() {
        double d = this.dynamicJFreeChartNode.getChart().getXYPlot().getDomainAxis().getLowerBound();
        double d2 = this.dynamicJFreeChartNode.getChart().getXYPlot().getDomainAxis().getUpperBound();
        double d3 = this.dynamicJFreeChartNode.getChart().getXYPlot().getRangeAxis().getLowerBound();
        double d4 = this.dynamicJFreeChartNode.getChart().getXYPlot().getRangeAxis().getUpperBound();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setFrameFromDiagonal(d, d3, d2, d4);
        return double_;
    }

    public void clear() {
        this.dynamicJFreeChartNode.clear();
    }

    public void addValue(int n, double d, double d2) {
        if (this.viewableRegionContains(d)) {
            this.dynamicJFreeChartNode.addValue(n, d, d2);
        }
    }

    private boolean viewableRegionContains(double d) {
        return d >= this.minViewableX && d <= this.maxViewableX;
    }

    public void setEditable(boolean bl) {
        this.jFreeChartSliderNode.setVisible(bl);
        this.jFreeChartSliderNode.setPickable(bl);
        this.jFreeChartSliderNode.setChildrenPickable(bl);
        this.graphTimeControlNode.setEditable(bl);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void forceUpdateAll() {
        this.dynamicJFreeChartNode.forceUpdateAll();
    }

    public static class Adapter
    implements Listener {
        public void controlFocusGrabbed() {
        }

        public void zoomChanged() {
        }

        public void valueChanged(double d) {
        }
    }

    public static interface Listener {
        public void controlFocusGrabbed();

        public void zoomChanged();

        public void valueChanged(double var1);
    }

    public class AlignedLayout
    implements Layout {
        private MinimizableControlGraph[] minimizableControlGraphs;

        public AlignedLayout(MinimizableControlGraph[] minimizableControlGraphArray) {
            this.minimizableControlGraphs = minimizableControlGraphArray;
        }

        public double[] getValues(LayoutFunction layoutFunction) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < this.minimizableControlGraphs.length; ++i) {
                if (this.minimizableControlGraphs[i].isMinimized()) continue;
                arrayList.add(new Double(layoutFunction.getValue(this.minimizableControlGraphs[i])));
            }
            double[] dArray = new double[arrayList.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)arrayList.get(i);
            }
            return dArray;
        }

        public void layout() {
            double d = 5.0;
            ControlGraph.this.graphTimeControlNode.setOffset(0.0, 0.0);
            ControlGraph.this.additionalControls.setOffset(0.0, ControlGraph.this.graphTimeControlNode.getFullBounds().getMaxY());
            LayoutFunction layoutFunction = new LayoutFunction(){

                public double getValue(MinimizableControlGraph minimizableControlGraph) {
                    double d = minimizableControlGraph.getControlGraph().graphTimeControlNode.getFullBounds().getWidth();
                    double d2 = minimizableControlGraph.getControlGraph().additionalControls.getFullBounds().getWidth();
                    return Math.max(d2, d);
                }
            };
            if (this.getNumberMaximized() == 0) {
                return;
            }
            ControlGraph.this.jFreeChartSliderNode.setOffset(this.max(this.getValues(layoutFunction)) + d, 0.0);
            LayoutFunction layoutFunction2 = new LayoutFunction(){

                public double getValue(MinimizableControlGraph minimizableControlGraph) {
                    return ControlGraph.getInsetX(minimizableControlGraph.getControlGraph().getJFreeChartNode());
                }
            };
            double d2 = this.max(this.getValues(layoutFunction2));
            double d3 = d2 - ControlGraph.getInsetX(ControlGraph.this.getJFreeChartNode());
            ControlGraph.this.dynamicJFreeChartNode.setBounds(0.0, 0.0, ControlGraph.this.getBounds().getWidth() - ControlGraph.this.zoomControl.getFullBounds().getWidth() - ControlGraph.this.jFreeChartSliderNode.getFullBounds().getMaxX() - d3, ControlGraph.this.getBounds().getHeight());
            ControlGraph.this.dynamicJFreeChartNode.setOffset(ControlGraph.this.jFreeChartSliderNode.getFullBounds().getMaxX() + d3, 0.0);
            ControlGraph.this.dynamicJFreeChartNode.updateChartRenderingInfo();
            ControlGraph.this.zoomControl.setOffset(ControlGraph.this.dynamicJFreeChartNode.getFullBounds().getMaxX(), ControlGraph.this.dynamicJFreeChartNode.getFullBounds().getCenterY() - ControlGraph.this.zoomControl.getFullBounds().getHeight() / 2.0);
            Rectangle2D rectangle2D = ControlGraph.this.dynamicJFreeChartNode.plotToNode(ControlGraph.this.getDataArea());
            ControlGraph.this.titleLayer.setOffset(rectangle2D.getX() + ControlGraph.this.dynamicJFreeChartNode.getOffset().getX(), rectangle2D.getY() + ControlGraph.this.dynamicJFreeChartNode.getOffset().getY());
        }

        private int getNumberMaximized() {
            int n = 0;
            for (int i = 0; i < this.minimizableControlGraphs.length; ++i) {
                MinimizableControlGraph minimizableControlGraph = this.minimizableControlGraphs[i];
                if (minimizableControlGraph.isMinimized()) continue;
                ++n;
            }
            return n;
        }

        private double max(double[] dArray) {
            double d = dArray[0];
            for (int i = 1; i < dArray.length; ++i) {
                if (!(dArray[i] > d)) continue;
                d = dArray[i];
            }
            return d;
        }
    }

    static interface LayoutFunction {
        public double getValue(MinimizableControlGraph var1);
    }

    public class FlowLayout
    implements Layout {
        public void layout() {
            double d = 5.0;
            ControlGraph.this.graphTimeControlNode.setOffset(0.0, 0.0);
            ControlGraph.this.additionalControls.setOffset(0.0, ControlGraph.this.graphTimeControlNode.getFullBounds().getMaxY());
            ControlGraph.this.jFreeChartSliderNode.setOffset(ControlGraph.this.graphTimeControlNode.getFullBounds().getMaxX() + d, 0.0);
            ControlGraph.this.dynamicJFreeChartNode.setBounds(0.0, 0.0, ControlGraph.this.getBounds().getWidth() - ControlGraph.this.zoomControl.getFullBounds().getWidth() - ControlGraph.this.jFreeChartSliderNode.getFullBounds().getMaxX(), ControlGraph.this.getBounds().getHeight());
            ControlGraph.this.dynamicJFreeChartNode.setOffset(ControlGraph.this.jFreeChartSliderNode.getFullBounds().getMaxX(), 0.0);
            ControlGraph.this.dynamicJFreeChartNode.updateChartRenderingInfo();
            ControlGraph.this.zoomControl.setOffset(ControlGraph.this.dynamicJFreeChartNode.getFullBounds().getMaxX(), ControlGraph.this.dynamicJFreeChartNode.getFullBounds().getCenterY() - ControlGraph.this.zoomControl.getFullBounds().getHeight() / 2.0);
            Rectangle2D rectangle2D = ControlGraph.this.dynamicJFreeChartNode.plotToNode(ControlGraph.this.getDataArea());
            ControlGraph.this.titleLayer.setOffset(rectangle2D.getX() + ControlGraph.this.dynamicJFreeChartNode.getOffset().getX(), rectangle2D.getY() + ControlGraph.this.dynamicJFreeChartNode.getOffset().getY());
            ControlGraph.this.setOffset(ControlGraph.this.getBounds().getX(), ControlGraph.this.getBounds().getY());
        }
    }

    public static interface Layout {
        public void layout();
    }

    public static class TitleLayer
    extends PhetPNode {
        public void addReadoutNode(ReadoutTitleNode readoutTitleNode) {
            readoutTitleNode.setOffset(this.getFullBounds().getWidth(), 0.0);
            this.addChild(readoutTitleNode);
        }

        public ReadoutTitleNode getReadoutNode(ControlGraphSeries controlGraphSeries) {
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                ReadoutTitleNode readoutTitleNode;
                if (!(this.getChild(i) instanceof ReadoutTitleNode) || (readoutTitleNode = (ReadoutTitleNode)this.getChild(i)).getSeries() != controlGraphSeries) continue;
                return readoutTitleNode;
            }
            return null;
        }
    }
}

