/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo.dynamic;

import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import org.jfree.data.xy.XYSeries;

public class SeriesData {
    private String title;
    private Color color;
    private Stroke stroke;
    private XYSeries series;
    private ArrayList listeners = new ArrayList();
    private static int index = 0;
    private boolean visible = true;

    public SeriesData(String string, Color color, Stroke stroke) {
        this(string, color, new XYSeries((Comparable)((Object)(string + " " + index++)), false, true), stroke);
    }

    public SeriesData(String string, Color color, XYSeries xYSeries, Stroke stroke) {
        this.title = string;
        this.color = color;
        this.series = xYSeries;
        this.stroke = stroke;
    }

    public Color getColor() {
        return this.color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public XYSeries getSeries() {
        return this.series;
    }

    public void addValue(double d, double d2) {
        this.series.add(d, d2);
        this.notifyDataAdded();
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        if (this.series.getItemCount() > 0) {
            this.series.clear();
            this.notifyDataCleared();
        }
    }

    private void notifyDataCleared() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).dataCleared();
        }
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.notifyVisibilityChanged();
        }
    }

    private void notifyVisibilityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).visibilityChanged();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyDataAdded() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).dataAdded();
        }
    }

    public static interface Listener {
        public void dataAdded();

        public void dataCleared();

        public void visibilityChanged();
    }
}

