/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;

public final class LinearMath
extends AbstractMath {
    private LinearMath() {
    }

    private static double[] solveCholesky(double[][] dArray, double[] dArray2) {
        int n;
        double d;
        int n2;
        int n3 = dArray2.length;
        double[] dArray3 = new double[n3];
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new DoubleSquareMatrix(dArray).choleskyDecompose();
        for (n2 = 0; n2 < n3; ++n2) {
            d = dArray2[n2];
            for (n = 0; n < n2; ++n) {
                d -= abstractDoubleSquareMatrixArray[0].getElement(n2, n) * dArray3[n];
            }
            dArray3[n2] = d / abstractDoubleSquareMatrixArray[0].getElement(n2, n2);
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            d = dArray3[n2];
            for (n = n2 + 1; n < n3; ++n) {
                d -= abstractDoubleSquareMatrixArray[1].getElement(n2, n) * dArray3[n];
            }
            dArray3[n2] = d / abstractDoubleSquareMatrixArray[1].getElement(n2, n2);
        }
        return dArray3;
    }

    public static AbstractDoubleVector linearRegression(double[][] dArray) {
        int n;
        double d;
        int n2;
        int n3 = dArray.length - 1;
        double[][] dArray2 = new double[dArray.length][dArray.length];
        double[] dArray3 = new double[dArray.length];
        dArray2[0][0] = dArray[0].length;
        for (n2 = 1; n2 < dArray.length; ++n2) {
            d = 0.0;
            for (n = 0; n < dArray[0].length; ++n) {
                d += dArray[n2 - 1][n];
            }
            double d2 = d;
            dArray2[n2][0] = d2;
            dArray2[0][n2] = d2;
        }
        double d3 = 0.0;
        for (n = 0; n < dArray[0].length; ++n) {
            d3 += dArray[n3][n];
        }
        dArray3[0] = d3;
        for (int i = 1; i < dArray.length; ++i) {
            for (n2 = i; n2 < dArray.length; ++n2) {
                d = 0.0;
                for (n = 0; n < dArray[0].length; ++n) {
                    d += dArray[i - 1][n] * dArray[n2 - 1][n];
                }
                double d4 = d;
                dArray2[n2][i] = d4;
                dArray2[i][n2] = d4;
            }
            d3 = 0.0;
            for (n = 0; n < dArray[0].length; ++n) {
                d3 += dArray[i - 1][n] * dArray[n3][n];
            }
            dArray3[i] = d3;
        }
        return new DoubleVector(LinearMath.solveCholesky(dArray2, dArray3));
    }
}

